/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.GraphDataSeriesImpl;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpManager.DpmClientApplet;
import ibm.nways.nhm.eui.NhmChart;
import ibm.nways.nhm.eui.NhmViewPage;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Observable;
import java.util.TimeZone;
import java.util.Vector;
import jclass.chart.ChartDataModelUpdate;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartRegion;
import jclass.chart.ChartText;
import jclass.chart.Chartable;
import jclass.chart.EventTrigger;
import jclass.chart.JCAxis;
import jclass.chart.JCAxisTitle;
import jclass.chart.JCBarChartFormat;
import jclass.chart.JCChart;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartTimeUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCLabelGenerator;
import jclass.chart.JCLegend;
import jclass.chart.JCPickEvent;
import jclass.chart.JCPickListener;
import jclass.chart.JCPieChartFormat;
import jclass.chart.JCTitle;

public class GraphInstance
extends Observable
implements Serializable,
Chartable,
JCPickListener,
JCLabelGenerator {
    public static final int GRAPH_MODE_NONE = -1;
    public static final int GRAPH_MODE_HISTORY = 0;
    public static final int GRAPH_MODE_POINT = 1;
    public static final int GRAPH_MODE_SUMMARY = 2;
    public static final int MAXIMUM_SERIES_TO_SHOW = 10;
    private static final Color otherColor = Color.white;
    private static final Color[] colors = new Color[]{Color.blue, Color.red, Color.green, Color.yellow, Color.magenta, Color.orange, Color.pink, Color.cyan, Color.lightGray, Color.gray};
    private static final int[] shapes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    JCChart chart;
    private int graphType;
    private String graphName;
    private String units;
    private boolean graphIsReadyForUpdate = false;
    private DateFormat df;
    private int mode = -1;
    private Date selectedDate;
    private Vector pois;
    private Vector graphDataSeries;
    private Date timeBase;

    public GraphInstance(String string, int n, String string2) {
        this.graphType = n;
        this.graphName = string;
        this.units = string2;
        if (this.units == null) {
            this.units = "";
        }
        this.pois = new Vector();
        this.graphDataSeries = new Vector();
        this.chart = new NhmChart();
        this.chart.getHeader().setIsShowing(true);
        this.chart.getHeader().getLabel().setText(string);
        this.chart.getLegend().setIsShowing(true);
        this.chart.getLegend().setAnchor(32);
        this.chart.setTrigger(0, new EventTrigger(0, 4));
        this.chart.setTrigger(1, new EventTrigger(1, 1));
        this.chart.setTrigger(2, new EventTrigger(8, 0));
        this.chart.setTrigger(3, new EventTrigger(2, 2));
        this.chart.getChartArea().setElevation(30);
        this.chart.getChartArea().setDepth(20);
        this.chart.getChartArea().setRotation(20);
        this.chart.getChartArea().setFastAction(true);
        this.chart.addPickListener(this);
        this.df = DateFormat.getDateTimeInstance(1, 1);
        this.df.setTimeZone(TimeZone.getDefault());
    }

    public void setGraphMode(int n, Date date) {
        ChartDataView chartDataView = this.chart.getDataView(0);
        String string = this.graphName;
        if (this.mode != n) {
            if (n == 1) {
                if (date == null) {
                    date = this.getLatestDate();
                }
                string = string.concat(" (" + JCChartTimeUtil.timeLabel("%c", date) + ")");
                this.chart.getHeader().getLabel().setText(string, false);
            } else {
                this.chart.getHeader().getLabel().setText(string, false);
            }
        }
        if (n == 1) {
            JCAxis jCAxis = chartDataView.getXAxis();
            jCAxis.setAnnotationMethod(3);
        } else {
            JCAxis jCAxis = chartDataView.getXAxis();
            jCAxis.setTimeUnit(1000L);
            jCAxis.setTimeBase(this.timeBase);
            jCAxis.setAnnotationMethod(2);
        }
        this.mode = n;
        this.chart.reset();
        this.graphUpdateAll();
    }

    public void setChartType(int n) {
        int n2 = 0;
        ChartDataView chartDataView = this.chart.getDataView(0);
        JCBarChartFormat jCBarChartFormat = chartDataView.getBarChartFormat();
        this.chart.setIsBatched(true);
        switch (n) {
            case 0: {
                n2 = 0;
                jCBarChartFormat.set100Percent(false);
                chartDataView.setChartType(0);
                break;
            }
            case 10: {
                n2 = 0;
                jCBarChartFormat.set100Percent(false);
                chartDataView.setChartType(10);
                break;
            }
            case -1: {
                n2 = 0;
                jCBarChartFormat.set100Percent(true);
                chartDataView.setChartType(10);
                break;
            }
            case 9: {
                n2 = 1;
                jCBarChartFormat.set100Percent(false);
                chartDataView.setChartType(9);
                break;
            }
            case 11: {
                n2 = 1;
                jCBarChartFormat.set100Percent(false);
                chartDataView.setChartType(11);
                break;
            }
        }
        this.setGraphMode(n2, this.selectedDate);
        if (chartDataView != null) {
            chartDataView.setChanged(true, 2);
        }
        this.chart.setIsBatched(false);
    }

    public void unregisterForEvents(DpmClientApplet dpmClientApplet) {
        Enumeration enumeration = this.graphDataSeries.elements();
        while (enumeration.hasMoreElements()) {
            GraphDataSeriesImpl graphDataSeriesImpl = (GraphDataSeriesImpl)enumeration.nextElement();
            graphDataSeriesImpl.unregisterForEvents(dpmClientApplet);
        }
    }

    public void registerForEvents(DpmClientApplet dpmClientApplet) {
        Enumeration enumeration = this.graphDataSeries.elements();
        while (enumeration.hasMoreElements()) {
            GraphDataSeriesImpl graphDataSeriesImpl = (GraphDataSeriesImpl)enumeration.nextElement();
            graphDataSeriesImpl.registerForEvents(dpmClientApplet);
        }
    }

    public void addToGraphData(GraphInstance graphInstance) {
        PollingObjectInstance pollingObjectInstance = null;
        String string = null;
        GraphDataSeriesImpl graphDataSeriesImpl = null;
        String string2 = null;
        Enumeration enumeration = graphInstance.pois.elements();
        while (enumeration.hasMoreElements()) {
            pollingObjectInstance = (PollingObjectInstance)enumeration.nextElement();
            if (!pollingObjectInstance.getValidNonZeroData()) continue;
            string = String.valueOf(pollingObjectInstance.getHostname()) + "." + pollingObjectInstance.getIdentifier();
            Vector vector = pollingObjectInstance.getHistory();
            if (vector.isEmpty()) continue;
            DataPoint dataPoint = (DataPoint)vector.elementAt(0);
            string2 = dataPoint.getID();
            this.timeBase = new Date(dataPoint.getDate());
            graphDataSeriesImpl = new GraphDataSeriesImpl(string, string2, pollingObjectInstance, this, this.timeBase, this.chart.getDataView(0).getHoleValue());
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                graphDataSeriesImpl.addDataPoint((DataPoint)enumeration2.nextElement());
            }
            this.graphDataSeries.addElement(graphDataSeriesImpl);
        }
    }

    public void setupGraphData(DpmClientApplet dpmClientApplet) {
        String string = null;
        Enumeration enumeration = this.pois.elements();
        while (enumeration.hasMoreElements()) {
            PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)enumeration.nextElement();
            if (!pollingObjectInstance.getValidNonZeroData()) continue;
            String string2 = String.valueOf(pollingObjectInstance.getHostname()) + "." + pollingObjectInstance.getIdentifier();
            Vector vector = pollingObjectInstance.getHistory();
            if (vector.isEmpty()) continue;
            GraphDataSeriesImpl graphDataSeriesImpl = null;
            DataPoint dataPoint = (DataPoint)vector.elementAt(0);
            string = dataPoint.getID();
            this.timeBase = new Date(dataPoint.getDate());
            graphDataSeriesImpl = new GraphDataSeriesImpl(string2, string, pollingObjectInstance, this, this.timeBase, this.chart.getDataView(0).getHoleValue());
            Enumeration enumeration2 = vector.elements();
            int n = 0;
            while (enumeration2.hasMoreElements()) {
                dataPoint = (DataPoint)enumeration2.nextElement();
                Date date = new Date(dataPoint.getDate());
                if (!date.before(this.timeBase)) {
                    graphDataSeriesImpl.addDataPoint(dataPoint);
                }
                ++n;
            }
            if (graphDataSeriesImpl == null) continue;
            graphDataSeriesImpl.registerForEvents(dpmClientApplet);
            this.graphDataSeries.addElement(graphDataSeriesImpl);
        }
    }

    public void setPollingObjectInstances(Vector vector) {
        this.pois = vector;
    }

    public void addPollingObjectInstances(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)enumeration.nextElement();
            this.pois.addElement(pollingObjectInstance);
        }
    }

    public int getGraphType() {
        return this.graphType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Graph Instances:");
        stringBuffer.append("\n Polling Object Instances = " + this.pois);
        return stringBuffer.toString();
    }

    public void graphUpdateSeries(GraphDataSeriesImpl graphDataSeriesImpl) {
        int n = this.graphDataSeries.indexOf(graphDataSeriesImpl) * 2;
        int n2 = n + 1;
        this.notifyGraphOfChanges(n);
        this.notifyGraphOfChanges(n2);
    }

    public void graphUpdateSeries(GraphDataSeriesImpl graphDataSeriesImpl, int n) {
        int n2 = this.graphDataSeries.indexOf(graphDataSeriesImpl) * 2;
        int n3 = n2 + 1;
        this.notifyGraphOfChanges(n2, n);
        this.notifyGraphOfChanges(n3, n);
    }

    public synchronized void notifyGraphOfChanges(int n) {
        this.setChanged();
        this.notifyObservers(new ChartDataModelUpdate(3, n, 0));
        this.clearChanged();
    }

    public synchronized void notifyGraphOfChanges(int n, int n2) {
        this.setChanged();
        this.notifyObservers(new ChartDataModelUpdate(1, n, n2));
        this.clearChanged();
    }

    public synchronized void graphUpdateAll() {
        this.setChanged();
        this.notifyObservers(new ChartDataModelUpdate(14, 0, 0));
        this.clearChanged();
    }

    public static Color getUniqueColor(int n) {
        int n2 = n % colors.length;
        int n3 = n / colors.length;
        Color color = new Color(colors[n2].getRGB());
        int n4 = 0;
        while (n4 < n3) {
            color = color.darker();
            ++n4;
        }
        return color;
    }

    public static int getUniqueShape(int n) {
        int n2 = n / colors.length;
        int n3 = n + n2;
        int n4 = n3 % shapes.length;
        return shapes[n4];
    }

    public JCChart getGraph() {
        return this.getGraph(null);
    }

    public JCChart getGraph(Container container) {
        Serializable serializable;
        JCChartStyle jCChartStyle;
        Serializable serializable2;
        ChartDataView chartDataView = this.chart.getDataView(0);
        chartDataView.setDataSource(this);
        this.setChartType(this.graphType);
        ChartDataViewSeries[] chartDataViewSeriesArray = chartDataView.getSeries();
        int n = 0;
        while (n < chartDataViewSeriesArray.length) {
            serializable2 = chartDataViewSeriesArray[n];
            jCChartStyle = new JCChartStyle();
            serializable = GraphInstance.getUniqueColor(n);
            int n2 = GraphInstance.getUniqueShape(n);
            jCChartStyle.setLineColor((Color)serializable);
            jCChartStyle.setFillColor((Color)serializable);
            jCChartStyle.setSymbolShape(n2);
            jCChartStyle.setSymbolColor((Color)serializable);
            ((ChartDataViewSeries)serializable2).setStyle(jCChartStyle);
            ++n;
        }
        serializable2 = chartDataView.getPieChartFormat();
        ((JCPieChartFormat)serializable2).setThresholdMethod(1);
        ((JCPieChartFormat)serializable2).setThresholdValue(0.0);
        ((JCPieChartFormat)serializable2).setMinSlices(10);
        jCChartStyle = new JCChartStyle();
        jCChartStyle.setFillColor(otherColor);
        ((JCPieChartFormat)serializable2).setOtherStyle(jCChartStyle);
        ((JCPieChartFormat)serializable2).setSortOrder(1);
        serializable = chartDataView.getYAxis();
        ((JCAxis)serializable).setTitle(new JCAxisTitle(this.units));
        ((JCAxis)serializable).getTitle().setRotation(3);
        ((JCAxis)serializable).getTitle().setPlacement(2);
        if (container != null) {
            JCTitle jCTitle = this.chart.getHeader();
            Font font = container.getFont();
            if (font != null) {
                Font font2 = new Font(font.getName(), 1, font.getSize());
                jCTitle.setFont(font2);
            }
        }
        return this.chart;
    }

    public void pick(JCPickEvent jCPickEvent) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        JCChart jCChart = null;
        JCDataIndex jCDataIndex = jCPickEvent.getPickResult();
        if (jCDataIndex != null) {
            Point[] pointArray;
            Point[] pointArray2;
            Serializable[] serializableArray;
            int n3;
            Object object = jCDataIndex.getObject();
            if (object instanceof ChartRegion) {
                ChartRegion chartRegion = (ChartRegion)object;
                jCChart = chartRegion.getParent();
            }
            int n4 = jCDataIndex.getDistance();
            ChartDataView chartDataView = jCDataIndex.getDataView();
            JCPieChartFormat jCPieChartFormat = null;
            if (chartDataView != null) {
                jCPieChartFormat = chartDataView.getPieChartFormat();
            }
            ChartDataViewSeries chartDataViewSeries = jCDataIndex.getSeries();
            String string = null;
            GraphDataSeriesImpl graphDataSeriesImpl = null;
            if (chartDataViewSeries != null) {
                string = chartDataViewSeries.getName();
                graphDataSeriesImpl = this.getGraphDataSeries(string);
            }
            if ((n3 = jCDataIndex.getSeriesIndex()) == -10) {
                bl3 = true;
            }
            int n5 = jCDataIndex.getPoint();
            if (object instanceof JCChartArea) {
                JCChartArea cfr_ignored_0 = (JCChartArea)object;
                if (n4 <= 5) {
                    if (chartDataView.getChartType() == 11 && chartDataView != null && n3 != -1) {
                        serializableArray = jCPieChartFormat.getExplodeList();
                        if (serializableArray != null) {
                            n = 0;
                            while (n < serializableArray.length) {
                                if (((Point)serializableArray[n]).x == n5 && ((Point)serializableArray[n]).y == n3) {
                                    pointArray2 = new Point[serializableArray.length - 1];
                                    n2 = 0;
                                    while (n2 < n) {
                                        pointArray2[n2] = serializableArray[n2];
                                        ++n2;
                                    }
                                    n2 = n;
                                    while (n2 < pointArray2.length) {
                                        pointArray2[n2] = serializableArray[n2 + 1];
                                        ++n2;
                                    }
                                    jCPieChartFormat.setExplodeList(pointArray2);
                                    bl = true;
                                    bl2 = true;
                                    break;
                                }
                                ++n;
                            }
                        }
                        if (!bl2) {
                            int n6 = 0;
                            if (serializableArray != null) {
                                n6 = serializableArray.length;
                            }
                            pointArray = new Point[n6 + 1];
                            n2 = 0;
                            while (n2 < n6) {
                                pointArray[n2] = serializableArray[n2];
                                ++n2;
                            }
                            pointArray[n6] = new Point(n5, n3);
                            jCPieChartFormat.setExplodeList(pointArray);
                            bl = true;
                        }
                    }
                    if (!bl3) {
                        Object object2;
                        double d = chartDataViewSeries.getY(n5);
                        double d2 = 0.0;
                        long l = 0L;
                        Date date = null;
                        if (this.mode == 0) {
                            d2 = chartDataViewSeries.getX(n5);
                            l = (long)(d2 * 1000.0);
                            date = new Date(l + this.timeBase.getTime());
                        } else if (this.mode == 1) {
                            date = this.selectedDate != null ? this.selectedDate : this.getLatestDate();
                            l = date.getTime() - this.timeBase.getTime();
                            d2 = Math.round(l / 1000L);
                        }
                        double d3 = 0.0;
                        double d4 = 0.0;
                        ChartDataViewSeries[] chartDataViewSeriesArray = chartDataView.getSeries();
                        n = 0;
                        while (n < chartDataViewSeriesArray.length) {
                            int n7 = chartDataViewSeriesArray[n].getX(d2);
                            object2 = chartDataViewSeriesArray[n].getName();
                            GraphDataSeriesImpl graphDataSeriesImpl2 = this.getGraphDataSeries((String)object2);
                            if (this.mode == 0) {
                                n7 = chartDataViewSeriesArray[n].getX(d2);
                                graphDataSeriesImpl2.setSelected(n7);
                            } else if (this.mode == 1) {
                                n7 = 0;
                            }
                            double d5 = chartDataViewSeriesArray[n].getY(n7);
                            if (d5 != chartDataView.getHoleValue()) {
                                d4 += d5;
                            }
                            ++n;
                        }
                        if (d4 > 0.0) {
                            d3 = d / d4;
                        }
                        if (graphDataSeriesImpl != null && jCChart != null) {
                            Applet applet = jCChart.getApplet();
                            object2 = jCChart.getFrame();
                            graphDataSeriesImpl.showDetails((Frame)object2, d3, applet);
                            if (this.mode == 0) {
                                this.selectedDate = date;
                            }
                        }
                    }
                } else {
                    jCChart.reset();
                    bl = true;
                }
            } else if (object instanceof JCLegend) {
                if (jCChart != null) {
                    jCChart.setIsBatched(true);
                }
                if (chartDataViewSeries != null) {
                    chartDataViewSeries.setIsShowing(false);
                    chartDataViewSeries.setIsIncluded(false);
                } else if (chartDataView != null) {
                    serializableArray = chartDataView.getSeries();
                    n = 0;
                    while (n < serializableArray.length) {
                        if (!((ChartDataViewSeries)serializableArray[n]).getIsShowing()) {
                            ((ChartDataViewSeries)serializableArray[n]).setIsShowing(true);
                            ((ChartDataViewSeries)serializableArray[n]).setIsIncluded(true);
                        }
                        ++n;
                    }
                }
                if (jCChart != null) {
                    jCChart.setIsBatched(false);
                }
            }
            if (jCChart != null && (serializableArray = jCChart.getParent()) instanceof Panel && (pointArray2 = serializableArray.getParent()) instanceof NhmViewPage) {
                pointArray = pointArray2;
                pointArray.setCurrentComponent((Component)jCChart);
            }
            if (chartDataView != null && bl) {
                chartDataView.setChanged(true, 2);
            }
        }
    }

    public int getDataInterpretation() {
        return 1;
    }

    public Object getDataItem(int n, int n2) {
        Double d = null;
        GraphDataSeriesImpl graphDataSeriesImpl = null;
        try {
            graphDataSeriesImpl = (GraphDataSeriesImpl)this.graphDataSeries.elementAt(n / 2);
        }
        catch (Exception exception) {
            System.out.println("Exception in getDataItem for row " + n + " column " + n2);
            exception.printStackTrace();
        }
        if (graphDataSeriesImpl != null) {
            d = n % 2 == 0 ? (this.mode == 1 ? new Double(0.0) : graphDataSeriesImpl.getDate(n2)) : (this.mode == 1 ? graphDataSeriesImpl.getSelectedValue() : graphDataSeriesImpl.getValue(n2));
        }
        return d;
    }

    public synchronized Vector getRow(int n) {
        Vector<Double> vector = null;
        GraphDataSeriesImpl graphDataSeriesImpl = null;
        try {
            graphDataSeriesImpl = (GraphDataSeriesImpl)this.graphDataSeries.elementAt(n / 2);
        }
        catch (Exception exception) {
            System.out.println("Exception in getRow for row " + n);
            exception.printStackTrace();
        }
        if (graphDataSeriesImpl != null) {
            if (n % 2 == 0) {
                if (this.mode == 1) {
                    vector = new Vector<Double>();
                    vector.addElement(new Double(0.0));
                } else {
                    vector = graphDataSeriesImpl.getDates();
                }
            } else if (this.mode == 1) {
                vector = new Vector();
                vector.addElement(graphDataSeriesImpl.getSelectedValue());
            } else {
                vector = graphDataSeriesImpl.getValues();
            }
        }
        return vector;
    }

    public int getNumRows() {
        return this.graphDataSeries.size() * 2;
    }

    public String[] getPointLabels() {
        String[] stringArray = null;
        return stringArray;
    }

    public String getSeriesName(int n) {
        String string = "";
        GraphDataSeriesImpl graphDataSeriesImpl = (GraphDataSeriesImpl)this.graphDataSeries.elementAt(n);
        if (graphDataSeriesImpl != null) {
            string = graphDataSeriesImpl.getName();
        }
        return string;
    }

    public String getSeriesLabel(int n) {
        return this.getSeriesName(n);
    }

    public String getName() {
        return this.graphName;
    }

    public Object makeLabel(double d, int n) {
        ChartDataView chartDataView = this.chart.getDataView(0);
        JCAxis jCAxis = chartDataView.getXAxis();
        Date date = jCAxis.valueToDate(d);
        ChartText chartText = new ChartText();
        String string = this.df.format(date);
        chartText.setText(string);
        return chartText;
    }

    public GraphDataSeriesImpl getGraphDataSeries(String string) {
        GraphDataSeriesImpl graphDataSeriesImpl = null;
        Enumeration enumeration = this.graphDataSeries.elements();
        while (enumeration.hasMoreElements()) {
            GraphDataSeriesImpl graphDataSeriesImpl2 = (GraphDataSeriesImpl)enumeration.nextElement();
            if (!string.equals(graphDataSeriesImpl2.getName())) continue;
            graphDataSeriesImpl = graphDataSeriesImpl2;
        }
        return graphDataSeriesImpl;
    }

    public synchronized Date getLatestDate() {
        Date date = new Date();
        boolean bl = false;
        Enumeration enumeration = this.graphDataSeries.elements();
        while (enumeration.hasMoreElements()) {
            GraphDataSeriesImpl graphDataSeriesImpl = (GraphDataSeriesImpl)enumeration.nextElement();
            Date date2 = graphDataSeriesImpl.getLatestDateObject();
            if (bl && !date2.after(date)) continue;
            bl = true;
            date = date2;
        }
        return date;
    }

    public Vector getGraphDataSeries() {
        return this.graphDataSeries;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public Vector getPollingObjectInstances() {
        return this.pois;
    }
}

